//
//  NSError+BIAdditions.h
//  BIViews
//
//  Created by Alykhan Jetha on 20/07/08.
//  Copyright 2008 Marketcircle Inc. All rights reserved.
//

#import <Cocoa/Cocoa.h>


@interface NSError (BIAdditions)

+ (NSError *)biErrorWithDescription:(NSString *)str recovery:(NSString *)rec code:(int)code;

+ (NSError *)biErrorWithLocalizedReason:(NSString *)str code:(int)errorCode;

// the path to the file is found in BIErrorFilePathKey
+ (NSError *)biErrorWithLocalizedReason:(NSString *)str code:(int)errorCode file:(NSString *)path;

+ (NSError *)biErrorWithLocalizedReason:(NSString *)str code:(int)errorCode file:(NSString *)path suspectObject:(id)anObject;


// returns the file which had the error
- (NSString *)biErrorFilePath;

// removes the path and extension
- (NSString *)biErrorFilename;

// the object that the error pertains too
- (id)biSuspectObject;

// if suspectObject responds to elementDisplayName, that is returned
- (NSString *)biReportElementName;

@end
